package gov.va.vinci.dart.db;

import java.util.List;

import org.testng.Assert;
import org.testng.annotations.BeforeTest;
import org.testng.annotations.Test;

import gov.va.vinci.dart.common.SingletonShim;
import gov.va.vinci.dart.common.test.BusinessIntegrationTest;
import gov.va.vinci.dart.biz.DartRequest;
import gov.va.vinci.dart.biz.Narrative;
import gov.va.vinci.dart.service.DartObjectFactory;

public class TestNarrativeDAO extends BusinessIntegrationTest {

	@BeforeTest
	public void setup() {
		SingletonShim.getBean(DartObjectFactory.class);
	}

	@Test
	public void testOne() throws Exception {
		List<DartRequest> reqList = DartObjectFactory.getInstance().getDartRequestDAO().listAll();
		Assert.assertNotNull(reqList);
		Assert.assertTrue(reqList.size() > 0);

		DartRequest req = reqList.get(0);
		Assert.assertNotNull(req);
		Assert.assertTrue(req.getId() > 0);
		
		Narrative narrative = Narrative.create("Narrative Description", req, "DNS", "Narrative Text");
		Assert.assertNotNull(narrative);
		Assert.assertTrue(narrative.getId() > 0);
		
		Narrative n2 = DartObjectFactory.getInstance().getNarrativeDAO().findById(narrative.getId());
		Assert.assertNotNull(n2);
		Assert.assertEquals(n2, narrative);
	}
}
